/*
 * Decompiled with CFR 0.152.
 */
package io.github.tanguygab.utilsexpansion;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.Configurable;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.expansion.Relational;
import me.clip.placeholderapi.expansion.Taskable;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class UtilsExpansion
extends PlaceholderExpansion
implements Relational,
Taskable,
Configurable {
    private final List<String> placeholders = new ArrayList<String>();
    private final Map<String, Object> defaults = new HashMap<String, Object>();
    private final Map<String, String> shortcuts = new HashMap<String, String>();

    public UtilsExpansion() {
        List<String> placeholders = List.of("parse", "parse:<num>", "color", "uncolor", "uncolor:each", "parseother:[name]", "parseplaceholder:[placeholder]", "parserel:[name]", "parserelplaceholder:[placeholder]", "escape", "try_<placeholder>", "trycatch:<defaultvalue>_<placeholder>", "default_<placeholder>", "default:<defaultvalue>_<placeholder>");
        placeholders.forEach(placeholder -> {
            this.placeholders.add("%utils_" + placeholder + "_<placeholder>%");
            this.placeholders.add("%rel_utils_" + placeholder + "_<placeholder>%");
        });
        this.defaults.put("shortcuts", new HashMap<String, String>(){
            {
                this.put("othermath", "%utils_parseother:[{0}]_math_{1}+1%");
            }
        });
    }

    @Nonnull
    public String getIdentifier() {
        return "utils";
    }

    @Nonnull
    public String getAuthor() {
        return "Tanguygab";
    }

    @Nonnull
    public String getVersion() {
        return "1.0.14";
    }

    @Nonnull
    public List<String> getPlaceholders() {
        return this.placeholders;
    }

    public Map<String, Object> getDefaults() {
        return this.defaults;
    }

    public void start() {
        ConfigurationSection shortcuts = this.getConfigSection("shortcuts");
        assert (shortcuts != null);
        shortcuts.getValues(false).forEach((name, shortcut) -> {
            this.shortcuts.put((String)name, shortcut.toString());
            this.placeholders.add("%utils_shortcut_" + name + ":arg0:arg1:...%");
            this.placeholders.add("%rel_utils_shortcut_" + name + ":arg0:arg1:...%");
        });
    }

    public void stop() {
    }

    public String onRequest(OfflinePlayer player, @Nonnull String params) {
        return this.process(params, player, null);
    }

    public String onPlaceholderRequest(Player viewer, Player target, String params) {
        return this.process(params, (OfflinePlayer)viewer, target);
    }

    private String process(String params, OfflinePlayer viewer, Player target) {
        String arg = params.split("_")[0];
        String text = params.substring(arg.length() + 1);
        if (arg.equalsIgnoreCase("escape")) {
            return "%" + text + "%";
        }
        if (arg.equalsIgnoreCase("shortcut")) {
            String[] args = text.split(":");
            String shortcut = args[0];
            if (!this.shortcuts.containsKey(shortcut)) {
                return "";
            }
            shortcut = this.shortcuts.get(shortcut);
            for (int i = 1; i < args.length; ++i) {
                shortcut = shortcut.replace("{" + (i - 1) + "}", args[i]);
            }
            return this.parsePlaceholders(shortcut, viewer, target);
        }
        if (arg.startsWith("parseother:[") && params.contains("]")) {
            String name = params.substring(12, params.indexOf("]"));
            return this.processParse(params.substring(params.indexOf("]") + 2), name.isEmpty() ? null : this.getPlayer(name), target);
        }
        if (arg.startsWith("parseplaceholder:[") && params.contains("]")) {
            String placeholder = params.substring(18, params.indexOf("]"));
            String name = this.processParse(placeholder, viewer, target).replace("%", "");
            return this.processParse(params.substring(params.indexOf("]") + 2), name.isEmpty() ? null : this.getPlayer(name), target);
        }
        if (arg.startsWith("parserel:[") && params.contains("]")) {
            String name = params.substring(10, params.indexOf("]"));
            return this.processParse(params.substring(params.indexOf("]") + 2), viewer, name.isEmpty() ? null : this.getPlayer(name).getPlayer());
        }
        if (arg.startsWith("parserelplaceholder:[") && params.contains("]")) {
            String placeholder = params.substring(21, params.indexOf("]"));
            String name = this.processParse(placeholder, viewer, target).replace("%", "");
            return this.processParse(params.substring(params.indexOf("]") + 2), viewer, name.isEmpty() ? null : this.getPlayer(name).getPlayer());
        }
        if (arg.equalsIgnoreCase("parsesync")) {
            if (Bukkit.isPrimaryThread()) {
                return this.processParse(text, viewer, target);
            }
            try {
                return (String)Bukkit.getServer().getScheduler().callSyncMethod((Plugin)this.getPlaceholderAPI(), () -> this.processParse(text, viewer, target)).get();
            }
            catch (Exception e) {
                return "<Error parsing placeholders synchronously>";
            }
        }
        if (arg.startsWith("parse")) {
            String[] args = arg.split(":");
            int number = 1;
            if (args.length > 1) {
                try {
                    number = Integer.parseInt(args[1]);
                }
                catch (Exception i) {
                    // empty catch block
                }
            }
            boolean percent = args.length < 3 || args[2].equalsIgnoreCase("true");
            return this.processParse(text, number, viewer, target, percent);
        }
        if (arg.equalsIgnoreCase("color")) {
            return this.color(this.processParse(text, viewer, target));
        }
        if (arg.startsWith("uncolor")) {
            return ChatColor.stripColor((String)this.color(this.processParse(text, 1, viewer, target, true, arg.equalsIgnoreCase("uncolor:each"))));
        }
        if (arg.startsWith("try")) {
            String def = arg.startsWith("trycatch:") ? arg.substring(9) : "";
            try {
                return this.processParse(text, viewer, target);
            }
            catch (Exception e) {
                return def;
            }
        }
        if (arg.startsWith("default")) {
            String def = arg.startsWith("default:") ? arg.substring(8) : "";
            String output = this.processParse(text, viewer, target);
            return output.isEmpty() || output.equals("%" + text + "%") ? def : output;
        }
        return null;
    }

    private OfflinePlayer getPlayer(String uuidOrName) {
        try {
            return Bukkit.getServer().getPlayer(UUID.fromString(uuidOrName));
        }
        catch (IllegalArgumentException e) {
            Player player = Bukkit.getServer().getPlayer(uuidOrName);
            if (player != null) {
                return player;
            }
            try {
                return Bukkit.getServer().getOfflinePlayerIfCached(uuidOrName);
            }
            catch (NoSuchMethodError er) {
                return Bukkit.getServer().getOfflinePlayer(uuidOrName);
            }
        }
    }

    private String color(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    private String processParse(String text, OfflinePlayer viewer, Player target) {
        return this.processParse(text, 1, viewer, target, true, false);
    }

    private String processParse(String text, int number, OfflinePlayer viewer, Player target, boolean percent) {
        return this.processParse(text, number, viewer, target, percent, false);
    }

    private String processParse(String text, int number, OfflinePlayer viewer, Player target, boolean percent, boolean uncolorEach) {
        if (percent) {
            text = "%" + (String)text + "%";
        }
        for (int i = 0; i < number; ++i) {
            text = this.parseBracketPlaceholders((String)text, viewer, target, uncolorEach);
            text = this.parsePlaceholders((String)text, viewer, target);
        }
        return text;
    }

    private String parsePlaceholders(String text, OfflinePlayer viewer, Player target) {
        text = PlaceholderAPI.setPlaceholders((OfflinePlayer)viewer, (String)text);
        if (target != null) {
            text = PlaceholderAPI.setRelationalPlaceholders((Player)viewer.getPlayer(), (Player)target, (String)text);
        }
        return text;
    }

    private String parseBracketPlaceholders(String params, OfflinePlayer viewer, Player target, boolean uncolorEach) {
        StringBuilder str = new StringBuilder(params);
        for (int i = str.length() - 1; i >= 0; --i) {
            boolean escaped;
            char c = str.charAt(i);
            boolean bl = escaped = i != 0 && str.charAt(i - 1) == '\\';
            if (escaped) {
                --i;
                continue;
            }
            if (c != '{') continue;
            int end = -1;
            for (int j = i + 2; j < str.length(); ++j) {
                if (str.charAt(j) != '}' || str.charAt(j - 1) == '\\') continue;
                end = j;
                break;
            }
            if (end == -1) continue;
            String placeholder = str.substring(i, end + 1);
            String parsed = this.parsePlaceholders("%" + placeholder.substring(1, placeholder.length() - 1) + "%", viewer, target);
            if (uncolorEach) {
                parsed = ChatColor.stripColor((String)this.color(parsed));
            }
            str.replace(i, end + 1, parsed);
        }
        return str.toString();
    }
}

