/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.formatterexpansion.formatters.number;

import ch.andre601.formatterexpansion.FormatterExpansion;
import ch.andre601.formatterexpansion.formatters.IFormatter;
import ch.andre601.formatterexpansion.utils.NumberUtils;
import ch.andre601.formatterexpansion.utils.StringUtils;
import ch.andre601.formatterexpansion.utils.logging.CachedWarnHelper;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class Round
implements IFormatter {
    private final FormatterExpansion expansion;

    public Round(FormatterExpansion expansion) {
        this.expansion = expansion;
    }

    @Override
    public String name() {
        return "round";
    }

    @Override
    public String parse(String raw, String option, String ... values) {
        int precision = this.expansion.getInt("rounding.precision", 0);
        String rounding = this.expansion.getString("rounding.mode", "half-up");
        if (values.length == 1) {
            return this.roundNumber(raw, values[0], precision, rounding);
        }
        String[] roundingOptions = StringUtils.getSplit(values[0], ":", 2);
        if (!StringUtils.isNullOrEmpty(roundingOptions[0])) {
            precision = NumberUtils.parseNumber(roundingOptions[0]);
        }
        if (!StringUtils.isNullOrEmpty(roundingOptions[1])) {
            rounding = roundingOptions[1];
        }
        return this.roundNumber(raw, StringUtils.merge(1, "", values), precision, rounding);
    }

    private String roundNumber(String raw, String number, int precision, String roundingMode) {
        BigDecimal decimal = NumberUtils.getBigDecimal(number);
        if (decimal == null) {
            CachedWarnHelper.warn(this.expansion, raw, "Cannot convert " + number + " to a BigDecimal.");
            return null;
        }
        if (precision < 0) {
            precision = 0;
        }
        RoundingMode mode = StringUtils.getRoundingMode(roundingMode);
        MathContext context = new MathContext(precision, mode);
        return decimal.round(context).toPlainString();
    }
}

