/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.formatterexpansion.formatters.number;

import ch.andre601.formatterexpansion.FormatterExpansion;
import ch.andre601.formatterexpansion.formatters.IFormatter;
import ch.andre601.formatterexpansion.utils.NumberUtils;
import ch.andre601.formatterexpansion.utils.StringUtils;
import ch.andre601.formatterexpansion.utils.logging.CachedWarnHelper;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class FromTo
implements IFormatter {
    private final FormatterExpansion expansion;

    public FromTo(FormatterExpansion expansion) {
        this.expansion = expansion;
    }

    @Override
    public String name() {
        return null;
    }

    @Override
    public String parse(String raw, String option, String ... values) {
        if (values.length < 2) {
            CachedWarnHelper.warn(this.expansion, "too-short", raw, "Placeholder to short. Requires from:<value>, to:<value> and <number>");
            return null;
        }
        if (StringUtils.isNullOrEmpty(values[0], values[1])) {
            CachedWarnHelper.warn(this.expansion, "null-values", raw, "Either to:<value> or <number> was empty/null.");
            return null;
        }
        if (!values[0].toLowerCase(Locale.ROOT).startsWith("to:")) {
            CachedWarnHelper.warn(this.expansion, "no-to", raw, "Placeholder does not have to:<value> set.");
            return null;
        }
        String from = StringUtils.getSplit(option, ":", 2)[1];
        String to = StringUtils.getSplit(values[0], ":", 2)[1];
        if (StringUtils.isNullOrEmpty(from, to)) {
            CachedWarnHelper.warn(this.expansion, "from-to-null", raw, "from:<value> and/or to:<value> had an empty/null <value>.");
            return null;
        }
        return this.convert(raw, StringUtils.merge(1, "", values), from, to);
    }

    private String convert(String raw, String number, String from, String to) {
        Long finalNumber = NumberUtils.optLong(number);
        if (finalNumber == null) {
            CachedWarnHelper.warn(this.expansion, "from-to-long", raw, "Cannot convert " + number + " into a long.");
            return null;
        }
        TimeUnit fromUnit = StringUtils.getTimeUnit(from);
        TimeUnit toUnit = StringUtils.getTimeUnit(to);
        if (fromUnit == null || toUnit == null) {
            CachedWarnHelper.warn(this.expansion, "from-to-invalid-timeunit", raw, "Unsupported time unit for either from:<value> or to:<value>.");
            return null;
        }
        finalNumber = toUnit.convert(finalNumber, fromUnit);
        return switch (toUnit) {
            case TimeUnit.DAYS -> finalNumber + this.expansion.getString("time.days", "d");
            case TimeUnit.HOURS -> finalNumber + this.expansion.getString("time.hours", "h");
            case TimeUnit.MINUTES -> finalNumber + this.expansion.getString("time.minutes", "m");
            case TimeUnit.SECONDS -> finalNumber + this.expansion.getString("time.seconds", "s");
            case TimeUnit.MILLISECONDS -> finalNumber + this.expansion.getString("time.milliseconds", "ms");
            default -> {
                CachedWarnHelper.warn(this.expansion, "unknown-to-time", raw, "Unknown target time unit '" + to + "'.");
                yield null;
            }
        };
    }
}

