/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.formatterexpansion.formatters.text;

import ch.andre601.formatterexpansion.FormatterExpansion;
import ch.andre601.formatterexpansion.formatters.IFormatter;
import ch.andre601.formatterexpansion.utils.StringUtils;
import ch.andre601.formatterexpansion.utils.logging.CachedWarnHelper;
import java.util.Locale;

public class Capitalize
implements IFormatter {
    private final FormatterExpansion expansion;

    public Capitalize(FormatterExpansion expansion) {
        this.expansion = expansion;
    }

    @Override
    public String name() {
        return "capitalize";
    }

    @Override
    public String parse(String raw, String option, String ... values) {
        Type type = Type.resolve(values[0]);
        if (values.length == 1 && type != null) {
            CachedWarnHelper.warn(this.expansion, raw, "Placeholder cannot have '!" + type.name().toLowerCase(Locale.ROOT) + "!' without any text.");
            return null;
        }
        String text = type == null ? String.join((CharSequence)"_", values) : StringUtils.merge(1, "_", values);
        if (text.length() == 1) {
            return text.toUpperCase(Locale.ROOT);
        }
        if (type == null) {
            return this.capitalize(text, false);
        }
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.NORMAL -> this.capitalize(text, false);
            case Type.STRICT -> this.capitalize(text, true);
            case Type.TITLE -> this.titleCase(text, false);
            case Type.TITLESTRICT -> this.titleCase(text, true);
        };
    }

    private String capitalize(String text, boolean strict) {
        return text.substring(0, 1).toUpperCase(Locale.ROOT) + (strict ? text.substring(1).toLowerCase(Locale.ROOT) : text.substring(1));
    }

    private String titleCase(String text, boolean strict) {
        StringBuilder titleCasedText = new StringBuilder(text.length());
        boolean nextCharUppercase = true;
        for (char c : text.toCharArray()) {
            if (Character.isSpaceChar(c)) {
                nextCharUppercase = true;
            } else if (nextCharUppercase) {
                titleCasedText.append(Character.toTitleCase(c));
                nextCharUppercase = false;
                continue;
            }
            if (strict) {
                titleCasedText.append(Character.toLowerCase(c));
                continue;
            }
            titleCasedText.append(c);
        }
        return titleCasedText.toString();
    }

    private static enum Type {
        NORMAL,
        STRICT,
        TITLE,
        TITLESTRICT;


        public static Type resolve(String input) {
            for (Type type : Type.values()) {
                if (!input.toUpperCase(Locale.ROOT).equals("!" + type.name() + "!")) continue;
                return type;
            }
            return null;
        }
    }
}

