/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.formatterexpansion.formatters.number;

import ch.andre601.formatterexpansion.FormatterExpansion;
import ch.andre601.formatterexpansion.formatters.IFormatter;
import ch.andre601.formatterexpansion.utils.NumberUtils;
import ch.andre601.formatterexpansion.utils.StringUtils;
import ch.andre601.formatterexpansion.utils.logging.CachedWarnHelper;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class Shorten
implements IFormatter {
    private final FormatterExpansion expansion;
    private final NavigableMap<Double, String> suffixes = new TreeMap<Double, String>();
    private final DecimalFormat format;

    public Shorten(FormatterExpansion expansion) {
        this.expansion = expansion;
        this.suffixes.put(1000.0, expansion.getString("shorten.thousands", "{{number}}K"));
        this.suffixes.put(1000000.0, expansion.getString("shorten.millions", "{{number}}M"));
        this.suffixes.put(1.0E9, expansion.getString("shorten.billions", "{{number}}B"));
        this.suffixes.put(1.0E12, expansion.getString("shorten.trillions", "{{number}}T"));
        this.suffixes.put(1.0E15, expansion.getString("shorten.quadrillions", "{{number}}Q"));
        this.suffixes.put(1.0E18, expansion.getString("shorten.quintillion", "{{number}}Qi"));
        this.suffixes.put(1.0E21, expansion.getString("shorten.sextillion", "{{number}}Sx"));
        this.suffixes.put(1.0E24, expansion.getString("shorten.septillion", "{{number}}Sp"));
        this.suffixes.put(1.0E27, expansion.getString("shorten.octillion", "{{number}}Oc"));
        this.suffixes.put(1.0E30, expansion.getString("shorten.nonillion", "{{number}}No"));
        this.suffixes.put(1.0E33, expansion.getString("shorten.decillion", "{{number}}Dc"));
        this.format = new DecimalFormat(expansion.getString("shorten.pattern", "###.#"));
    }

    @Override
    public String name() {
        return "shorten";
    }

    @Override
    public String parse(String raw, String option, String ... values) {
        RoundingMode defRoundingMode = StringUtils.getRoundingMode(this.expansion.getString("shorten.rounding_mode", "half-up"));
        if (values.length == 1) {
            return this.truncateNumber(raw, values[0], defRoundingMode);
        }
        RoundingMode roundingMode = defRoundingMode;
        String number = StringUtils.merge(1, "", values);
        if (!StringUtils.isNullOrEmpty(values[0]) && (roundingMode = StringUtils.getNullableRoundingMode(values[0])) == null) {
            roundingMode = defRoundingMode;
            number = StringUtils.merge(0, "", values);
        }
        return this.truncateNumber(raw, number, roundingMode);
    }

    private String truncateNumber(String raw, String value, RoundingMode roundingMode) {
        Double number = NumberUtils.optDouble(value);
        if (number == null) {
            CachedWarnHelper.warn(this.expansion, raw, "Cannot convert " + value + " to a double.");
            return null;
        }
        return this.truncateNumber(number, roundingMode);
    }

    private String truncateNumber(Double number, RoundingMode roundingMode) {
        if (number == Double.MIN_VALUE) {
            return this.truncateNumber(1.0, roundingMode);
        }
        if (number < 0.0) {
            return "-" + this.truncateNumber(-number.doubleValue(), roundingMode);
        }
        this.format.setRoundingMode(roundingMode);
        if (number < 1000.0) {
            return this.format.format(number);
        }
        Map.Entry<Double, String> entry = this.suffixes.floorEntry(number);
        double divideBy = entry.getKey();
        Object text = entry.getValue();
        if (!((String)text).toLowerCase(Locale.ROOT).contains("{{number}}")) {
            text = "{{number}}" + (String)text;
        }
        double truncated = number / (divideBy / 10.0);
        return ((String)text).replace("{{number}}", this.format.format(truncated / 10.0));
    }
}

