/*
 * Decompiled with CFR 0.152.
 */
package fake.replaceOutputExpansion;

import fake.replaceOutputExpansion.Config;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.Cacheable;
import me.clip.placeholderapi.expansion.Configurable;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class ReplaceOutputExpansion
extends PlaceholderExpansion
implements Cacheable,
Configurable {
    private final Map<String, Map<String, String>> replacements = new HashMap<String, Map<String, String>>();
    private boolean debug = false;

    @NotNull
    public String getIdentifier() {
        return "ReplaceOutput";
    }

    @NotNull
    public String getAuthor() {
        return "FakEE7";
    }

    @NotNull
    public String getVersion() {
        return "1.0";
    }

    public Map<String, Object> getDefaults() {
        return Map.of();
    }

    @Nonnull
    public List<String> getPlaceholders() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, Map<String, String>> entry : this.replacements.entrySet()) {
            String placeholderName = entry.getKey();
            result.add("%replaceoutput_" + placeholderName + "_<value>%");
        }
        return result;
    }

    public void clear() {
        this.replacements.clear();
        this.debug("Cleared all cached data");
    }

    public boolean register() {
        ConfigurationSection replacementsSection;
        FileConfiguration config = new Config(this).load();
        ConfigurationSection settings = config.getConfigurationSection("Settings");
        if (settings != null) {
            this.debug = settings.getBoolean("Debug", false);
        }
        if ((replacementsSection = config.getConfigurationSection("Replacements")) != null) {
            for (String placeholderName : replacementsSection.getKeys(false)) {
                ConfigurationSection placeholderSection = replacementsSection.getConfigurationSection(placeholderName);
                if (placeholderSection == null) continue;
                LinkedHashMap<String, String> placeholderConfig = new LinkedHashMap<String, String>();
                for (String condition : placeholderSection.getKeys(false)) {
                    String replacement = placeholderSection.getString(condition);
                    placeholderConfig.put(condition, replacement);
                    this.debug("Loading condition '" + condition + "' with replacement '" + replacement + "' for placeholder '" + placeholderName + "'");
                }
                this.replacements.put(placeholderName, placeholderConfig);
            }
        }
        this.debug("Loaded placeholder configurations");
        return super.register();
    }

    public String onRequest(OfflinePlayer player, @NotNull String params) {
        String[] parts = this.processNestedPlaceholders(player, params).split("_", 2);
        if (parts.length < 2) {
            this.debug("Invalid format for params: " + params + ". Expected: placeholderName_value");
            return "";
        }
        String placeholderName = parts[0];
        String value = parts[1];
        Map<String, String> placeholderConfig = this.replacements.get(placeholderName);
        if (placeholderConfig == null) {
            this.debug("No configuration found for placeholder: " + placeholderName);
            return value;
        }
        String result = this.processReplacement(player, placeholderConfig, value).replace("%value%", value);
        this.debug("Processed " + placeholderName + " with value '" + value + "' -> '" + result + "'");
        return this.processNestedPlaceholders(player, result);
    }

    private String processReplacement(OfflinePlayer player, Map<String, String> config, String value) {
        if (config.containsKey(value)) {
            return config.get(value);
        }
        for (Map.Entry<String, String> entry : config.entrySet()) {
            String condition = entry.getKey();
            if (condition.equals("else") || !this.matchesCondition(this.processNestedPlaceholders(player, condition), value)) continue;
            this.debug("Value matches condition: " + condition);
            return config.get(condition);
        }
        if (config.containsKey("else")) {
            String result = config.get("else");
            this.debug("Using else clause for value: " + value);
            return result;
        }
        this.debug("No match found for value: " + value + ", returning original");
        return value;
    }

    private boolean matchesCondition(String condition, String value) {
        try {
            String[] parts = condition.split("::", 2);
            String conditionType = parts[0].toLowerCase();
            String baseConditionValue = parts.length > 1 ? parts[1] : "";
            String conditionValue = baseConditionValue.replace("%value%", value);
            boolean negated = conditionType.startsWith("!");
            if (negated) {
                conditionType = conditionType.substring(1);
            }
            switch (conditionType.toLowerCase()) {
                case "~~": 
                case "range": {
                    String[] rangeParts = conditionValue.split("~", 2);
                    if (rangeParts.length != 2) {
                        return false;
                    }
                    double numValue = Double.parseDouble(value);
                    double first = Double.parseDouble(rangeParts[0]);
                    double second = Double.parseDouble(rangeParts[1]);
                    double min = Math.min(first, second);
                    double max = Math.max(first, second);
                    boolean inRange = min <= numValue && numValue <= max;
                    return negated != inRange;
                }
                case "==": 
                case "equals": {
                    boolean equals = value.equals(conditionValue);
                    return negated != equals;
                }
                case "equalsignorecase": {
                    boolean equalsIgnore = value.equalsIgnoreCase(conditionValue);
                    return negated != equalsIgnore;
                }
                case "startswith": {
                    boolean startsWith = value.startsWith(conditionValue);
                    return negated != startsWith;
                }
                case "endswith": {
                    boolean endsWith = value.endsWith(conditionValue);
                    return negated != endsWith;
                }
                case "startendwith": {
                    String[] seeParts = conditionValue.split("~", 2);
                    if (seeParts.length == 2) {
                        boolean startsEndsWith = value.startsWith(seeParts[0]) && value.endsWith(seeParts[1]);
                        return negated != startsEndsWith;
                    }
                    return false;
                }
                case "contains": {
                    boolean contains = value.contains(conditionValue);
                    return negated != contains;
                }
                case "containsignorecase": {
                    boolean containsIgnore = value.toLowerCase().contains(conditionValue.toLowerCase());
                    return negated != containsIgnore;
                }
                case ">": 
                case "greater": {
                    double numValue1 = Double.parseDouble(value);
                    double compareValue1 = Double.parseDouble(conditionValue);
                    return negated ? numValue1 <= compareValue1 : numValue1 > compareValue1;
                }
                case "<": 
                case "lower": {
                    double numValue2 = Double.parseDouble(value);
                    double compareValue2 = Double.parseDouble(conditionValue);
                    return negated ? numValue2 >= compareValue2 : numValue2 < compareValue2;
                }
                case ">=": 
                case "greaterthan": {
                    double numValue3 = Double.parseDouble(value);
                    double compareValue3 = Double.parseDouble(conditionValue);
                    return negated ? numValue3 < compareValue3 : numValue3 >= compareValue3;
                }
                case "<=": 
                case "lowerthan": {
                    double numValue4 = Double.parseDouble(value);
                    double compareValue4 = Double.parseDouble(conditionValue);
                    return negated ? numValue4 > compareValue4 : numValue4 <= compareValue4;
                }
            }
        }
        catch (NumberFormatException e) {
            this.debug("Invalid numeric value for condition: " + condition + " with value: " + value);
        }
        return false;
    }

    private String processNestedPlaceholders(OfflinePlayer offlinePlayer, String identifier) {
        while (((String)identifier).contains("{") && ((String)identifier).contains("}")) {
            int startIndex = ((String)identifier).lastIndexOf("{");
            int endIndex = ((String)identifier).indexOf("}", startIndex);
            if (startIndex == -1 || endIndex == -1) break;
            String placeholderName = ((String)identifier).substring(startIndex + 1, endIndex);
            String placeholderValue = PlaceholderAPI.setPlaceholders((Player)((Player)offlinePlayer), (String)("%" + placeholderName + "%"));
            identifier = ((String)identifier).substring(0, startIndex) + placeholderValue + ((String)identifier).substring(endIndex + 1);
        }
        return identifier;
    }

    private void debug(String message) {
        if (this.debug) {
            System.out.println(this.getIdentifier() + " [DEBUG] - " + message);
        }
    }
}

